#include <Adafruit_BME280.h>
#include <EEPROM.h>
#include <ESP8266WiFi.h>
#include <ESP8266WebServer.h>
#include <ESP8266HTTPClient.h>
#include <ESP8266HTTPUpdateServer.h>
#include <WiFiClientSecureBearSSL.h>
// firmware version
const char* Version = "Ver.1.0";
//************** Set your default parameters here **************
const char* _mySSID = "mySSID";              // set you Wifi SSID (name)
const char* _myPassword = "myPassword";         // set you Wifi password
const char* _SensorName = "ESP8266 BME280";   // set the sensor name
const char* _Host = "sending-domain.tmep.cz";  // set domain for sending values
const uint _HostPort = 80;                    // server port http = 80 or https = 443
const char* _GUID = "tempV";                  //
const char* _GUID_2 = "humV";                 //
const char* _GUID_3 = "pressV";               //
const uint _SendPeriod = 5;                   // Periodic time for sending data [minutes], MAX = 60 min.!
bool _SendToTmep = true;                      // Send data to tmep.cz false = stop, true = sends
bool _SensorInside = true;                    // where the sensor is located true=inside, false=outside
bool _AbsolutePressure = false;               // displays and sends absolute pressure or pressure converted to sea level
bool _DeepSleep = false;                      // disable / enable DeepSleep mode
float _AltitudeLocal = 185.0;                 // the station altitude in meters
const char* _AdminName = "admin";             // set you admin  name for management and OTA update firmware
const char* _AdminPassword = "admin";         // set your admin password for management and OTA update firmware
//**************************************************************
const char* OTAPath = "/3";                  // path for firmware update
const uint8_t Rounding = 1;                  // rounding of float numeric output
const uint8_t Length = 19;                   // Length of array with trend pressure data
const uint8_t ButtonPin = D7;                // GPIO13 button pin
const uint8_t SDAI2CPin = D2;                // GPIO4   I2C SDA bus
const uint8_t SCLI2CPin = D1;                // GPIO5   I2C SCL bus
const uint8_t BME280Addr = 0x77;             // Set BME280 I2C address
const uint32_t SensorReadPeriod = 60000L;    // [ms] Periodic time for sensor read
const uint32_t TrendPressPeriod = 600000L;   // [ms] Periodic time for calculation of trend
const uint32_t HostResponseTimeOut = 2000L;  // [ms] Timeout of host response
IPAddress _TheLastIPaddress = 0;
uint32_t SensorMillisTemp = 0L, TrendMillisTemp = 0L, SendMillisTemp = 0L, WifiModeFlag = 0L;
int rssi;
uint FreeHeap;
float SeaPressure, Pressure, Temperature, Humidity, Trend, PressureOld[Length];
float Vcc, PercentRssi;
String TimeString, MacAddrStr, MessageStr, SymbolRefresh = "&#9899;";
struct myStruct {
  char MD5[33];
  char mySSID[33], myPassword[64], SensorName[33], Host[64];
  char GUID[33], GUID_2[33], GUID_3[33];
  uint SendPeriod, HostPort;
  bool SensorInside, SendToTmep, AbsolutePressure, DeepSleep;
  float AltitudeLocal;
  IPAddress TheLastIPaddress;
};
myStruct eGet;
//-----------------------------------------------------------------
ESP8266WebServer httpserver(80);
ESP8266HTTPUpdateServer httpUpdater;
Adafruit_BME280 bme280;
ADC_MODE(ADC_VCC);
//-----------------------------------------------------------------
void setup(void) {
  pinMode(ButtonPin, INPUT_PULLUP);
  pinMode(LED_BUILTIN, OUTPUT);
  digitalWrite(LED_BUILTIN, HIGH);
  Serial.begin(115200);
  CheckMD5();
  Wire.begin(SDAI2CPin, SCLI2CPin);
  bme280.begin(BME280Addr);
  WifiStart();
  MacAddrStr = WiFi.macAddress();
  if (WiFi.getMode() == WIFI_STA) {
    Serial.print(F("\r\n\r\nThe sensor IP address is "));
    Serial.println(WiFi.localIP());
  }
  // Configure OTA server
  httpUpdater.setup(&httpserver, OTAPath, _AdminName, _AdminPassword);
  // Configure HTTP server
  httpserver.on("/", Preview);
  httpserver.on("/1", Form1);
  httpserver.on("/2", Form2);
  httpserver.on("/styly.css", HandleStyle);
  httpserver.on("/Analyse1", HTTP_POST, HandleForm1);
  httpserver.on("/Analyse2", HTTP_POST, HandleForm2);
  httpserver.onNotFound(handleNotFound);
  httpserver.begin();
  SensorSet();
  PressureTrendPrepare();
  Serial.flush();
  Serial.end();
}
//-----------------------------------------------------------------
void loop(void) {
  // listen for HTTP requests from local clients
  httpserver.handleClient();
  // periodically reads data from sensor BME280
  if ((millis() - SensorReadPeriod > SensorMillisTemp && millis() > SensorReadPeriod) || (SensorMillisTemp == 0L)) {
    SensorMillisTemp = millis();
    SensorRead();
    ESPParamsRead();
  }
  // periodically counts pressure trend
  if ((millis() - TrendPressPeriod > TrendMillisTemp && millis() > TrendPressPeriod) || (TrendMillisTemp == 0L)) {
    TrendMillisTemp = millis();
    TrendCalc();
  }
  // periodically sends data to the host
  if (((millis() - eGet.SendPeriod > SendMillisTemp) && (millis() > eGet.SendPeriod)) || (SendMillisTemp == 0L)) {
    SendMillisTemp = millis();
    if (eGet.SendToTmep && WiFi.getMode() == WIFI_STA)
      SendData();
  }
  // save the last IP address
  if (WiFi.getMode() == WIFI_STA && eGet.TheLastIPaddress != WiFi.localIP()) {
    eGet.TheLastIPaddress = WiFi.localIP();
    EEPROMWrite();
  }
  // from WiFi station mode pressing the hardware Smart Button restarts the system
  if (!digitalRead(ButtonPin) && (WiFi.getMode() == WIFI_STA)) {
    WifiModeSelectorFlag();
  }
  // flashing LED and start DeepSleep mode
  if (WiFi.getMode() == WIFI_STA && eGet.DeepSleep == true) {
    for (int i = 0; i < 20; i++) {
      delay(50);
      digitalWrite(LED_BUILTIN, !digitalRead(LED_BUILTIN));
    }
    digitalWrite(LED_BUILTIN, HIGH);//LED OFF
    // DeepSleep interval is in uS
    ESP.deepSleep(eGet.SendPeriod * 1000, WAKE_RF_DEFAULT);
  }
}