// save a parameters to flash
void EEPROMWrite(void) {
  EEPROM.begin(sizeof(eGet));
  EEPROM.put(0, eGet);
  EEPROM.end();
}
// geting parameters from flash
void EEPROMRead(void) {
  EEPROM.begin(sizeof(eGet));
  EEPROM.get(0, eGet);
  EEPROM.end();
}
void SetDefaultParameters(void) {
  ESP.getSketchMD5().toCharArray(eGet.MD5, 33);
  strcpy(eGet.mySSID, _mySSID);
  strcpy(eGet.myPassword, _myPassword);
  strcpy(eGet.SensorName, _SensorName);
  strcpy(eGet.Host, _Host);
  strcpy(eGet.GUID, _GUID);
  strcpy(eGet.GUID_2, _GUID_2);
  strcpy(eGet.GUID_3, _GUID_3);
  eGet.SendPeriod = (_SendPeriod * 60000);  // minutes to millis
  eGet.HostPort = _HostPort;
  eGet.SensorInside = _SensorInside;
  eGet.SendToTmep = _SendToTmep;
  eGet.AbsolutePressure = _AbsolutePressure;
  eGet.DeepSleep = _DeepSleep;
  eGet.AltitudeLocal = _AltitudeLocal;
  eGet.TheLastIPaddress = _TheLastIPaddress;
}
// test attribute "new sketch uploaded"
void CheckMD5(void) {
  bool NotMD5Hash = false;
  ESP.getSketchMD5().toCharArray(eGet.MD5, 33);
  EEPROM.begin(sizeof(eGet));
  for (uint8_t i = 0; i < 32; i++) {
    if (EEPROM.read(i) != eGet.MD5[i]) {
      NotMD5Hash = true;
    }
  }
  EEPROM.end();
  if (NotMD5Hash) {
    // set default parameters from PGM
    SetDefaultParameters();
    EEPROMWrite();
  } else {
    // set parameters from "EEPROM"
    EEPROMRead();
  }
}
