// handle Submit button and GET parameters
void HandleForm1(void) {
  if (httpserver.arg("Wsubmit") == F("SUBMIT")) {
    MessageStr = "";
    SymbolRefresh = SymbolRefresh == F("&#9899;") ? F("&#9898;") : F("&#9899;");
    ESP.getSketchMD5().toCharArray(eGet.MD5, 33);
    httpserver.arg("WmySSID").toCharArray(eGet.mySSID, httpserver.arg("WmySSID").length() + 1);
    httpserver.arg("WmyPassword").toCharArray(eGet.myPassword, httpserver.arg("WmyPassword").length() + 1);
    httpserver.arg("WSensorName").toCharArray(eGet.SensorName, httpserver.arg("WSensorName").length() + 1);
    httpserver.arg("WHost").toCharArray(eGet.Host, httpserver.arg("WHost").length() + 1);
    eGet.HostPort = httpserver.arg("WHostPort").toInt();
    httpserver.arg("WGUID").toCharArray(eGet.GUID, httpserver.arg("WGUID").length() + 1);
    httpserver.arg("WGUID_2").toCharArray(eGet.GUID_2, httpserver.arg("WGUID_2").length() + 1);
    httpserver.arg("WGUID_3").toCharArray(eGet.GUID_3, httpserver.arg("WGUID_3").length() + 1);

    if (httpserver.arg("WDefault") == "on") {
      SetDefaultParameters();
    }

    httpserver.sendHeader("Location", "/1");
    httpserver.send(303, F("text/plain"), "");
    EEPROMWrite();
    SensorMillisTemp = 0L;
    SendMillisTemp = 0L;
    if (httpserver.arg("Wrestart") == "on") ESP.restart();
  }
}

void HandleForm2(void) {
  if (httpserver.arg("Wsubmit") == F("SUBMIT")) {
    MessageStr = "";
    SymbolRefresh = SymbolRefresh == F("&#9899;") ? F("&#9898;") : F("&#9899;");
    ESP.getSketchMD5().toCharArray(eGet.MD5, 33);
    httpserver.arg("WSensorName").toCharArray(eGet.SensorName, httpserver.arg("WSensorName").length() + 1);
    eGet.SendPeriod = httpserver.arg("WSendPeriod").toInt() * 60000;
    if (eGet.SendPeriod < 60000) eGet.SendPeriod = 60000;
    if (eGet.SendPeriod > 3600000) eGet.SendPeriod = 3600000;
    eGet.AltitudeLocal = httpserver.arg("WAltitudeLocal").toFloat();
    if (httpserver.arg("WSensorInside") == "on") eGet.SensorInside = true;
    else eGet.SensorInside = false;

    if (httpserver.arg("WSendToTmep") == "on") {
      if (eGet.SendToTmep != true) {
        eGet.SendToTmep = true;
        if (WiFi.getMode() == WIFI_AP) MessageStr = F("<div style=\"color: red\">Local access point now only!</div>");
      }
    } else {
      if (eGet.SendToTmep != false) {
        eGet.SendToTmep = false;
        MessageStr = F("Sending data is disabled");
      }
    }

    if (httpserver.arg("WAbsolutePressure") == "on") {
      eGet.AbsolutePressure = true;
    } else {
      eGet.AbsolutePressure = false;
    }

    if (httpserver.arg("WDeepSleep") == "on") {
      if (eGet.DeepSleep != true) {
        eGet.DeepSleep = true;
        MessageStr = F("Deep sleep is set!");
      }
    } else {
      eGet.DeepSleep = false;
    }

    if (httpserver.arg("WDefault") == "on") {
      SetDefaultParameters();
    }

    if (httpserver.arg("WOTAUpdate") == "on") {
      httpserver.sendHeader("Location", "/3");
      httpserver.send(303, F("text/plain"), "");
    } else {
      httpserver.sendHeader("Location", "/2");
      httpserver.send(303, F("text/plain"), "");
    }
    EEPROMWrite();
    SensorMillisTemp = 0L;
    SendMillisTemp = 0L;
    if (httpserver.arg("Wrestart") == "on") ESP.restart();
  }
}
