// connecting http or https client to the host and send data via GET method
void SendData(void) {
  String URIStringToSend = "/?" + String(eGet.GUID)
                           + "=" + String(Temperature, Rounding)
                           + "&" + String(eGet.GUID_2)
                           + "=" + String(Humidity, Rounding)
                           + "&" + String(eGet.GUID_3)
                           + "=" + String((eGet.AbsolutePressure ? Pressure : SeaPressure) / 100.0, Rounding)
                           + "&rssi=" + String(rssi);
  if (eGet.HostPort == 80) {
    WiFiClient client;
    HTTPClient http;
    http.setTimeout(HostResponseTimeOut);
    // flash LED once when send data
    digitalWrite(LED_BUILTIN, LOW);
    delay(100);
    digitalWrite(LED_BUILTIN, HIGH);
    http.begin(client, eGet.Host, eGet.HostPort, URIStringToSend);
    int httpResponseCode = http.GET();
    ParsingServerResponse(http.getString());
    if (httpResponseCode == HTTP_CODE_OK) {
      MessageStr = F("<div style=\"color: green\">The host's response is OK</div>");
    } else if (httpResponseCode == 404) {
      MessageStr = F("<div style=\"color: red\">This is an invalid domain name</div>");
    } else if (httpResponseCode == 422) {
      MessageStr = F("<div style=\"color: red\">Bad parameters in GET body</div>");
    } else if (httpResponseCode == 401) {
      MessageStr = F("<div style=\"color: red\">This domain is not for sending data</div>");
    } else if (httpResponseCode <= 0) {
      MessageStr = F("<div style=\"color: red\">") + http.errorToString(httpResponseCode) + F("</div>");
    } else MessageStr = F("<div style=\"color: red\">Server state code - ") + String(httpResponseCode) + F("</div>");
    client.stop();
    http.end();
    return;

  } else {
    // https secure client
    std::unique_ptr<BearSSL::WiFiClientSecure> client(new BearSSL::WiFiClientSecure);
    // Ignore SSL certificate validation
    client->setInsecure();
    HTTPClient http;
    http.setTimeout(HostResponseTimeOut);
    // flash LED once when send data
    digitalWrite(LED_BUILTIN, !digitalRead(LED_BUILTIN));
    delay(100);
    digitalWrite(LED_BUILTIN, !digitalRead(LED_BUILTIN));
    //begin(*client,host,port,uri,https=true/false)
    http.begin(*client, eGet.Host, eGet.HostPort, URIStringToSend, true);
    int httpResponseCode = http.GET();
    ParsingServerResponse(http.getString());
    if (httpResponseCode == HTTP_CODE_OK) {
      MessageStr = F("<div style=\"color: green\">The host's response is OK</div>");
    } else if (httpResponseCode == 404) {
      MessageStr = F("<div style=\"color: red\">This is an invalid domain name</div>");
    } else if (httpResponseCode == 422) {
      MessageStr = F("<div style=\"color: red\">Bad parameters in GET body</div>");
    } else if (httpResponseCode == 401) {
      MessageStr = F("<div style=\"color: red\">This domain is not for sending data</div>");
    } else if (httpResponseCode <= 0) {
      MessageStr = F("<div style=\"color: red\">") + http.errorToString(httpResponseCode) + F("</div>");
    } else MessageStr = F("<div style=\"color: red\">Server state code - ") + String(httpResponseCode) + F("</div>");
    client->stop();
    http.end();
    return;
  }
}
