void SensorSet(void) {
  // BME280 - forced mode, 1x temperature / 1x humidity / 1x pressure oversampling, filter off
  bme280.setSampling(Adafruit_BME280::MODE_FORCED,
                     Adafruit_BME280::SAMPLING_X1,  // temperature
                     Adafruit_BME280::SAMPLING_X1,  // pressure
                     Adafruit_BME280::SAMPLING_X1,  // humidity
                     Adafruit_BME280::FILTER_OFF);
}
// read BME280 sensor in forced mode
void SensorRead(void) {
  const float StdTemp = 15.0;  // [Celsius] Standard temperature
  bme280.takeForcedMeasurement();
  // wait for sensor
  delay(20);
  Temperature = bme280.readTemperature();
  Pressure = bme280.readPressure();
  Humidity = bme280.readHumidity();
  // conversion to sea level pressure, sensor inside or outside
  if (eGet.SensorInside) {
    SeaPressure = Pressure / pow(1.0 - 0.0065 * eGet.AltitudeLocal / (StdTemp + 273.15), 5.255);  // as BOSCH formula
  } else {
    SeaPressure = Pressure / pow(1.0 - 0.0065 * eGet.AltitudeLocal / (Temperature + 273.15), 5.255);  // ICAO formula
  }
}
// read a parameters from ESP8266
void ESPParamsRead(void) {
  // reading internal ESP8266 chip voltage
  Vcc = ESP.getVcc() / 1000.0;
  // reading ESP8266 free memory
  FreeHeap = ESP.getFreeHeap();
  //reading and convert ESP8266 WiFi strength
  rssi = WiFi.RSSI();
  rssi = (isnan(rssi) ? -100 : rssi);
  PercentRssi = min(max(2 * (rssi + 100), 0), 100);
  // conversion of millis to time string DD:HH:MM
  uint32_t times = millis() / 1000;
  uint8_t days = (uint8_t)floor(times / 86400);
  uint8_t hours = (uint8_t)floor((times % 86400) / 3600);
  uint8_t mins = (uint8_t)floor((times % 3600) / 60);
  TimeString = (days < 10 ? "0" + String(days) : String(days))
               + ":" + (hours < 10 ? "0" + String(hours) : String(hours))
               + ":" + (mins < 10 ? "0" + String(mins) : String(mins));
}

//prepare buffer for pressure trend calculation
void PressureTrendPrepare(void) {
  SensorRead();
  for (int i = 0; i < (Length - 1); i++) TrendCalc();
}

// Shift an old pressure data for trend in buffer
void TrendCalc(void) {
  PressureOld[Length - 2] = Pressure;
  for (int i = 0; i < (Length - 2); i++) {
    PressureOld[i] = PressureOld[i + 1];
  }
  Trend = Pressure - PressureOld[0];
}
