void WifiStart(void) {
  ESP.rtcUserMemoryRead(0, &WifiModeFlag, sizeof(WifiModeFlag));
  if (WifiModeFlag == 0xAAAAAAAA) {
    // start WiFi Access point
    WifiModeFlag = 0x00000000;
    ESP.rtcUserMemoryWrite(0, &WifiModeFlag, sizeof(WifiModeFlag));
    WiFi.softAP(eGet.SensorName);
    digitalWrite(LED_BUILTIN, LOW);  //LED ON
    MessageStr = F("<div style=\"color: red\">Local access point now only !</div>");
  } else {
    // start WiFi station
    WiFi.mode(WIFI_STA);
    WiFi.begin(eGet.mySSID, eGet.myPassword);
    // wait for WiFi connect
    while (WiFi.status() != WL_CONNECTED) {
      WifiModeSelectorFlag();
      delay(250);
      digitalWrite(LED_BUILTIN, !digitalRead(LED_BUILTIN));
    }
    digitalWrite(LED_BUILTIN, HIGH);  //LED OFF
  }
}
// tests solid Smart button press and triggers a restart
void WifiModeSelectorFlag(void) {
  if (!digitalRead(ButtonPin)) {
    delay(50);
    if (!digitalRead(ButtonPin)) {
      WifiModeFlag = 0xAAAAAAAA;
      ESP.rtcUserMemoryWrite(0, &WifiModeFlag, sizeof(WifiModeFlag));
      // waiting for the button to be released
      while (!digitalRead(ButtonPin)) { delay(50); }
      ESP.restart();
    }
  }
}
//READ_PERI_REG(0x6000071C)