/*
  // 11.1.2020   ver.6.0 ok final
  Hlavní stanice WiFi ePaper 5.83inch č/b
  Tato WiFi meteostanice odesílá data na web: tmep.cz(EU)!!

  Aktualizace se provádí jednou za 20 minut (volitelné)

  Část kódu je inspirován od autora:
  https://wiki.tmep.cz/doku.php?id=zarizeni:esp8266

  Přepracoval: Josef Zvolánek
  https://twitter.com/JosefZvolanek

  - Založené na ESP32 LOLIN D32 Nové!! Using Lolin D32 V1.0 or maybe V2.0
  - Zobrazení naměřeních údajů na ePaper Waveshare 5.83inch č/b
  - Měření teploty a vlhkosti čidlem SHT31-D (SHT35-D)
  - Měření Tlaku čidlem BME280 + upravená knihovna ,,bme.Sleep,,
  - Měření napětí baterie + grafické zobrazení-ikona - David Bird
  - Měření signálu WiFi + grafické zobrazeni-ikona(nová upravená ikona u od ver.3)
  - Zobracení času aktualizace
  - Zobrazení WiFi připojení a domény
  - Přidáno dalších fontů pro lepší čitelnost bez degradace.
  - Úprava spolehlivosti I2c sběrnice pro čidlo SHT31-D na delším kabelu
  - Upravený výpočet přesnosti baterie 100k+100k(LOLIN D32) převodník - Davidem Birdem
    (Lolin má integrovaný odporový dělič 100k+100k)
    https://github.com/G6EJD/LiPo_Battery_Capacity_Estimator

  Tento kód je chráněn autorským právem (c) Josef Zvolánek
  Nesmí být použit pro komerční využití!!!
*/
#include <Adafruit_Sensor.h> // Adafruit knihovna
#include "Adafruit_SHT31.h"  // knihovna pro STH31
#include <WiFi.h>            // WiFi knihovna
#include <Wire.h>
#include <time.h>            //čas
#include <Adafruit_GFX.h>    //grafická knihovna pro ePaper
#include <Adafruit_GFX.h>    //grafická knihovna pro ePaper
#include <SPI.h>
#include <Adafruit_BME280.h> //knihovna pro BME280 + uprava!!
#include "driver/rtc_io.h"   //ESP32
#include "esp_deep_sleep.h"  //ESP32

RTC_DATA_ATTR int slide = 0;

//I2C
#define SDA 21 //STH31+BME280
#define SCL 22 //STH31+BME280

//ePaper
#define ENABLE_GxEPD2_GFX 0
#include <GxEPD2_BW.h>
#include <GxEPD2_3C.h>
//rozlišení ePaper 5.83
#define SCREEN_WIDTH  448.0
#define SCREEN_HEIGHT 600.0

//Icony
#include "icons.h"

//Fonty
#include <Fonts/FreeSansBold9pt7b.h>
#include "epaper_fonts.h" // includes fonts: DejaVu_Sans_Bold_11 or DSEG7_Classic_Bold_21 or DSEG7_Classic_Bold_11

// E-Paper pins to ESP32 GPIO pins e.g. LOLIN32 D32 or most ESP32 development boards
static const uint8_t EPD_BUSY = 4;
static const uint8_t EPD_CS   = 5;
static const uint8_t EPD_RST  = 16; // Lolin D32 Pro pin N/A, suggest use 12
static const uint8_t EPD_DC   = 17; // Lolin D32 Pro pin N/A, suggest use 13
static const uint8_t EPD_SCK  = 18;
static const uint8_t EPD_MISO = 19; // Master-In Slave-Out not used, as no data from display
static const uint8_t EPD_MOSI = 23;

// ePaper 5.83
GxEPD2_BW<GxEPD2_583, GxEPD2_583::HEIGHT > display(GxEPD2_583(/*CS=5*/ EPD_CS, /*DC=*/ EPD_DC, /*RST=*/ EPD_RST, /*BUSY=*/ EPD_BUSY));

// WiFi-nastavení
const char* ssid    = "xxxx"; // WiFi SSID-zadejte vaše SSID
const char* pass    = "xxxx"; // WiFi password-zadejte vaše Wifi heslo
const char* domain  = "xxxx";  // domain.tmep.cz 
const char* guid    = "xxxx";   // mojemereni

//###################################################

String      time_str_hodiny;
String      time_str_datum;
String      IP_Address;
int         StartTime, CurrentHour = 0, CurrentMin = 0, CurrentSec = 0, rssi;
const char* Timezone = "CET-1CEST-2,M3.5.0/02:00:00,M10.5.0/03:00:00";  // Central Europe

//################  VERSION  ##########################
String version = "sw.v6";       // Program version
//################  VERSION  ##########################

Adafruit_SHT31 sht31 = Adafruit_SHT31();//I2C

Adafruit_BME280 bme; // I2C
#define SEALEVELPRESSURE_HPA 1013.25
float pressure_offset = 45;   // Offset for calibration purposes, your altitude might be a lot different!
float altitude_offset = 30;   // Offset for calibration purposes, your altitude might be a lot different!

int SleepDuration = 20; // jak dlouho bude zařízení spát

void setup() {
  // Start serial
  Serial.begin(115200);
  Serial.println(String(version));
  delay(10);
  setCpuFrequencyMhz(120); // Nastaven CPU32 na 120 Mhz

//spolehlivost I2c
  pinMode(SDA, HIGH);
  pinMode(SCL, HIGH);
  Wire.setClock(50000);
  
  sht31.begin(0x44); // I2C address: 0x44 or 0x45 SHT31-D
  bme.begin(0x76); //BME280 alt.
  
  //ePaper
  Serial.println();
  display.init(0); // ePaper display
  display.setFullWindow();
  display.fillScreen(GxEPD_WHITE);
  display.setRotation(0);

  // Connect to the WiFi
  Serial.print("Připojeno "); Serial.println(ssid);
  WiFi.begin(ssid, pass);
  while (WiFi.status() != WL_CONNECTED) {
    rssi       = WiFi.RSSI();
    IP_Address = WiFi.localIP().toString(),
    delay(500);
    Serial.print(".");

  }
  Serial.println();
  Serial.println("WiFi connected");
  Serial.print("IP address: "); Serial.println(WiFi.localIP());
  Serial.println();
  long rssi = WiFi.RSSI();
  Serial.print("RSSI-WiFi:");
  Serial.println(String (rssi) + "dB");
  delay(3000);
}

void loop() {
  //čidlo-Adafruit_ BME280
  Serial.println("Pressure  = " + String(bme.readPressure() / 100.0F + pressure_offset) + " hPa");
  float BME280_p = bme.readPressure()/100.0F + pressure_offset;
  
  //čidlo-Adafruit_SHT31-D
  float t = sht31.readTemperature();
  float h = sht31.readHumidity();

  while (isnan(t) ||  isnan(h)) {
    t = sht31.readTemperature();
    h = sht31.readHumidity();
    if (! isnan(t)) {  // check if 'is not a number'
      Serial.print("Temp *C = "); Serial.println(t);
    } else {
      Serial.println("Failed to read temperature");
    }

    if (! isnan(h)) {  // check if 'is not a number'
      Serial.print("Hum. % = "); Serial.println(h);
    } else {
      Serial.println("Failed to read humidity");
    }
  }
  
  // Connect to the HOST and send data via GET method
  WiFiClient client; // Use WiFiClient class to create TCP connections

  char host[50];            // Joining two chars is little bit difficult. Make new array, 50 bytes long
  strcpy(host, domain);     // Copy /domain/ in to the /host/
  strcat(host, ".tmep.cz"); // Add ".tmep.cz" at the end of the /host/. /host/ is now "/domain/.tmep.cz"
  const int httpPort = 80;
  Serial.print("Pripojeno:  "); Serial.println(host);//xxxx.tmep.cz
  if (!client.connect(host, httpPort)) {
    // If you didn't get a connection to the server
    Serial.println("Špatné připojení");
    return;
  }
  Serial.println("Client Připojeno");

  // Make an url. We need: /?guid=t&humV=h
  String url = "/?";
  url += guid;
  url += "=";
  url += t;
  url += "&humV=";
  url += h;
  Serial.print("Requesting URL: "); Serial.println(url);

  // Make a HTTP GETrequest.
  client.print(String("GET ") + url + " HTTP/1.1\r\n" +
               "Host: " + host + "\r\n" +
               "Connection: close\r\n\r\n");

  // Workaroud for timeout
  unsigned long timeout = millis();
  while (client.available() == 0) {
    if (millis() - timeout > 5000) {
      Serial.println(">>> Client Timeout !");
      // client.stop();
      return;
    }
  }
  client.stop();
  {
    //######################################################
    //Zobrazení x, y na ePaper
    //Teplota-WEB tmep.cz
    display.setFont(&FreeSansBold9pt7b);
    DisplayString(1, 80, 65, "TEPLOTA", GxEPD_BLACK);
    display.setFont(&DSEG7_Classic_Bold_21);
    DisplayString(3, 60, 145, String(t, 1) + "'C", GxEPD_BLACK);
    Serial.print("Teplota: "); Serial.println(t);
    display.drawBitmap(5, 60, TEPLOMER, 54, 100, GxEPD_BLACK);
    display.drawBitmap(225, 160, METEORSTANICE11, 120, 155, GxEPD_BLACK);//METEORSTANICE
    display.drawLine(346, 25, 346, 448, GxEPD_BLACK); //vertikál1
    display.drawLine(350, 25, 350, 448, GxEPD_BLACK); //vertikál2
    display.drawBitmap(260, 27, SLUNICKO, 80, 80, GxEPD_BLACK);

    //Vlkost-WEB tmep.cz
    Serial.print("Vlhkost: "); Serial.println(h);
    display.setFont(&FreeSansBold9pt7b);
    display.setTextColor(GxEPD_BLACK);
    //display.setFont(&DejaVu_Sans_Bold_11);
    DisplayString(1, 80, 185, "VLHKOST", GxEPD_BLACK);
    display.setFont(&DSEG7_Classic_Bold_11);
    DisplayString(4, 65, 250, String(h, 1) + "%", GxEPD_BLACK);
    display.drawBitmap(0, 185, Vlhkost2, 80, 80, GxEPD_BLACK);//Vlhkost2

    //Rosny bod-WEB tmep.cz
    Serial.print("ROSNY BOD: "); Serial.println(t - (100 - h) / 5);
    display.setFont(&FreeSansBold9pt7b);
    DisplayString(1, 120, 355, "ROSNY BOD", GxEPD_BLACK);
    display.setFont(&DSEG7_Classic_Bold_11);
    DisplayString(4, 100, 420, String(t - ((100 - h) / 5), 1) + "'C", GxEPD_BLACK); // Only accurate if RH > 50%!
    display.drawBitmap(5, 340, ROSNYBOD, 90, 90, GxEPD_BLACK); //ROSNYBOD
 
 //BME280 ePaper Tlak - nikam se data neposílají!
    display.setFont(&FreeSansBold9pt7b);
    DisplayString(1, 80, 275, "TLAK-hPa:", GxEPD_BLACK);
    display.setFont(&DSEG7_Classic_Bold_11);
    DisplayString(3, 45, 320, String(BME280_p, 1), GxEPD_BLACK);
   display.drawBitmap(1, 280, Barometr, 50, 50, GxEPD_BLACK);//Barometr
    
    //######################################################

    //Baterie_data - David Bird
    uint8_t percentage = 100;
    float voltage = analogRead(35) / 4096.0 * 7.10;// LOLIN D32 (no voltage divider need already fitted to board. only needed for NODEMCU ESP32 with 100K+100K voltage divider
    percentage = 2808.3808 * pow(voltage, 4) - 43560.9157 * pow(voltage, 3) + 252848.5888 * pow(voltage, 2) - 650767.4615 * voltage + 626532.5703;
    if (voltage >= 4.20) percentage = 100;
    if (voltage <= 3.30) percentage = 0;

    //ePaper zobrazení
    Battery(530, 195, 3, percentage); //Ikona Baterie ePaper
    display.setFont(&FreeSansBold9pt7b);
    DisplayString(1, 495, 240, String(voltage, 2) + "v " + String(percentage) + "%", GxEPD_BLACK); // napětí baterie ePaper
    Serial.println("V = " + String(voltage, 3) + "v");
    Serial.println("% = " + String(percentage) + "%");;
  }

  //######################################################

  //ČAS aktualizace
  configTime(1, 1, "europe.pool.ntp.org", "time.nist.gov");
  setenv("TZ", Timezone, 1);
  Serial.println(F("\nWaiting for time"));
  while (!time(nullptr)) {
    delay(500);
  }
  time_t now = time(nullptr);
  delay(1000);
  struct tm *now_tm;
  int hour, min, second, day, month, year;
  now = time(NULL);
  now_tm = localtime(&now);
  hour   = now_tm->tm_hour;
  min    = now_tm->tm_min;
  second = now_tm->tm_sec;
  day    = now_tm->tm_mday;
  month  = now_tm->tm_mon+1;
  year   = now_tm->tm_year + 1900;
  String time_str_hodiny = (hour < 10 ? "0" + String(hour) : String(hour)) + ":" + (min < 10 ? "0" + String(min) : String(min)) + ":" + (second < 10 ? "0" + String(second) : String(second));
  String time_str_datum = (day < 10 ? "0" + String(day) : String(day)) + "/" + (month < 10 ? "0" + String(month) : String(month)) + "/" + (year < 10 ? "0" + String(year) : String(year));

  Serial.println(time_str_hodiny);
  Serial.println(time_str_datum);

  //ePaper-čas + datum aktualizace
  display.setTextColor(GxEPD_BLACK);
  display.setFont(&DSEG7_Classic_Bold_21);
  DisplayString(2, 360, 110, String(time_str_hodiny), GxEPD_BLACK);//čas aktualizace
  DisplayString(1, 400, 140, String(time_str_datum), GxEPD_BLACK);//datum aktualizace

  //######################################################
  display.setFont(&FreeSansBold9pt7b);
  DisplayString(1, 380, 50, "Aktualizace - tmep.cz: " , GxEPD_BLACK);

  display.setFont(&FreeSansBold9pt7b);
  DisplayString(1, 210, 18, "- - - - - - - -", GxEPD_BLACK); //vaše město
  display.drawLine(0, 25, 600, 23, GxEPD_BLACK);     //linka1 horní
  DisplayString(1, 70, 18, String(version), GxEPD_BLACK);//veze SW.

  //######################################################
  //aktualizace ePaper
  display.display(false);
  //######################################################

  //ESP32-Spát
  display.hibernate();
  bme.Sleep();
  pinMode(2, INPUT);
  pinMode(5, INPUT);
  pinMode(EPD_BUSY, INPUT);
  pinMode(EPD_CS, INPUT);
  pinMode(EPD_RST, INPUT);
  pinMode(EPD_DC, INPUT);
  pinMode(EPD_SCK, INPUT);
  pinMode(EPD_MISO, INPUT);
  pinMode(EPD_MOSI, INPUT);
  rtc_gpio_isolate(GPIO_NUM_4);
  Serial.println();
  Serial.println("Jdu spát! :-) ");
  Serial.println("Cas aktualizace vzhuru : " + String((millis() - StartTime) / 1000.00, 3) + "-secs");
  Serial.println("Jak dlouho budu spat: " + String(SleepDuration * 60) + "-secs of sleep time");
  esp_sleep_enable_timer_wakeup(SleepDuration * 60 * 1000000LL);
  esp_deep_sleep_start(); //  Doba spanku> 20minut
  delay(400);
}
//######################################################
void DisplayString(int fsize, int x, int y, String text, int font_colour) {
  display.setTextColor(font_colour);
  display.setTextSize(fsize);
  display.setCursor(x, y);
  display.print(text);
}
//######################################################
// Grafická ikona baterie
void Battery(int x, int y, int scale, int percent) {
  int linesize = 2;
  display.fillRect(x, y, scale * 9, linesize + 5 * scale, GxEPD_BLACK);
  display.fillRect(x + linesize, y + linesize, scale * 7.8, linesize + 3.8 * scale, GxEPD_WHITE);
  display.fillRect(x + 9 * scale, y + linesize * scale / 1.3, scale * 1, linesize + scale * 2, GxEPD_BLACK);
  // if (percent >= 12.5) display.fillRect(x+linesize+scale*0.8,y+linesize*scale/1.3,scale*1,linesize*scale*1.7, GxEPD_BLACK);
  if (percent >= 12.5) display.fillRect(x + linesize + scale * 0.8, y + linesize * scale / 1.3, scale * 1, linesize * scale * 1.7, (percent < 25 ? GxEPD_RED : GxEPD_BLACK));
  if (percent >= 25)   display.fillRect(x + linesize + scale * 2.5, y + linesize * scale / 1.3, scale * 1, linesize * scale * 1.7, GxEPD_BLACK);
  if (percent >= 50)   display.fillRect(x + linesize + scale * 4.3, y + linesize * scale / 1.3, scale * 1, linesize * scale * 1.7, GxEPD_BLACK);
  if (percent >= 75)   display.fillRect(x + linesize + scale * 5.8, y + linesize * scale / 1.3, scale * 1, linesize * scale * 1.7, GxEPD_BLACK);
  //######################################################
//linky
  display.drawLine(350, 150, 600, 150, GxEPD_BLACK);//napravo 2
  display.drawLine(350, 185, 600, 185, GxEPD_BLACK);//napravo 3
  display.drawLine(350, 250, 600, 250, GxEPD_BLACK);//napravo 4
  display.drawLine(350, 280, 600, 280, GxEPD_BLACK);//napravo 5
  display.drawLine(350, 310, 600, 310, GxEPD_BLACK);//napravo 6
  display.drawLine(350, 340, 600, 340, GxEPD_BLACK);//napravo 7
  display.drawLine(350, 370, 600, 370, GxEPD_BLACK);//napravo 8

//TWITTER ePaper
  display.setFont(&FreeSansBold9pt7b);
  display.drawBitmap(360, 375, TWITTER, 65, 65, GxEPD_BLACK);
  DisplayString(1, 440, 405, "twitter.com/", GxEPD_BLACK);
  DisplayString(1, 440, 425, "Josef Zvolanek", GxEPD_BLACK);

//Zobrazení síli WiFi signálu na ePaper
  display.setFont(&FreeSansBold9pt7b);
  DisplayString(1, 395, 175, "WiFi: ", GxEPD_BLACK);//WiFi
  display.drawLine(480, 150, 480, 185, GxEPD_BLACK); //vertikál3
   DisplayString(1, 510, 175, "Baterie: ", GxEPD_BLACK);//Baterie
  RSSI(345, 210, WiFi.RSSI());// WiFi grafická ikona

//IP. adresa - zobrazená na ePaper
  display.setFont(&FreeSansBold9pt7b);
  display.setCursor(385 / 1, 300 / 1); display.print("IP.adresa:  " + WiFi.localIP().toString());
//O2 HOST ADSL
  DisplayString(1, 385, 330, "Pripojeno:  " + String(ssid), GxEPD_BLACK);
  //Doména
  DisplayString(1, 365, 360, "Domena: " + String(domain), GxEPD_BLACK); display.print(".tmep.cz"); //tmep.cz
  //Spát-Deep Sleep na ePaper
  DisplayString(1, 385, 270, "Deep Sleep:  " + String(SleepDuration * 60),GxEPD_BLACK);display.print("-secs");
}
//######################################################

//Výpočet zobrazení WiFi signálu
void RSSI(int x, int y, int rssi) {
  int WIFIsignal = 0;
  int xpos = 1;
  for (int _rssi = -100; _rssi <= rssi; _rssi = _rssi + 20) {
    if (_rssi <= -20)  WIFIsignal = 20; //            <-20dbm displays 8-bars
    if (_rssi <= -40)  WIFIsignal = 18; //  -40dbm to  -18dbm displays 7-bars
    if (_rssi <= -50)  WIFIsignal = 16; //  -40dbm to  -16dbm displays 6-bars
    if (_rssi <= -60)  WIFIsignal = 14; //  -60dbm to  -14dbm displays 5-bars
    if (_rssi <= -70)  WIFIsignal = 12; //  -80dbm to  -12dbm displays 4-bars
    if (_rssi <= -80)  WIFIsignal = 10; //  -80dbm to  -10dbm displays 3-bars
    if (_rssi <= -90)  WIFIsignal = 8;  // -100dbm to  -8dbm  displays 2-bar
    if (_rssi <= -100) WIFIsignal = 6;  // -100dbm to  -6dbm  displays 1-bar
    display.fillRect(x + xpos * 5 + 60, y - WIFIsignal, 4, WIFIsignal, GxEPD_BLACK);
    xpos++;
  }
  display.fillRect(x + 60, y - 1, 4, 1, GxEPD_BLACK);
  DisplayString(1, 380, 240, String(rssi) + "dBm", GxEPD_BLACK); //WiFi data na ePaper
}
//KONEC :-)
