// read parameters from ESP8266
void ReadParam(void) {
  // reading internal ESP8266 chip voltage
  Vcc = ESP.getVcc() / 1000.0;
  // reading ESP8266 free memory
  FreeHeap = ESP.getFreeHeap();
  //reading and convert ESP8266 WiFi strength
  rssi = WiFi.RSSI();
  rssi = (isnan(rssi) ? -100 : rssi);
  PercentRssi = min(max(2 * (rssi + 100), 0), 100);
}
