// Connecting client to the host and send data via GET method
void SendData(void) {
  // clear response
  response = "";
  VisibleCharCounter = 0;
  // change dot in message row
  if (SymbolRefresh == F("&#9899;"))SymbolRefresh = F("&#9898;");
  else SymbolRefresh = F("&#9899;");
  // if the connection to the host failed
  if (!client.connect(host, 80)) {
    message = F("<div style=\"color: red\">Connection to host failed !</div>");
    client.stop();
    return;
  }
  message = F("<div style=\"color: green\">Connection to host successful</div>");
  // Make string to send
  String StringToSend = "GET /?" + String(guid) + "=" + String(temperature, FloatRounding) + "&humV=" + String(humidity, FloatRounding) + " HTTP/1.1\r\n" +
                        "Host: " + host + "\r\n" +
                        "Connection: close\r\n\r\n";
  // sending a HTTP GET request
  client.print(StringToSend);
  // flash LED_BUILTIN once when send data
  digitalWrite(2, LOW); delay(100); digitalWrite(2, HIGH);
  // wait for data to be available or timeout
  unsigned long TimeTemp = millis();
  while (client.available() == 0) {
    if (millis() - TimeTemp > 1000L) {
      message = F("<div style=\"color: red\">Host not respond - time out !</div>");
      client.stop();
      return;
    }
  }
  // Read all the chars and lines of the reply from host
  while (client.available()) {
    char temp = client.read();
    // convert data to HTML format
    HtmlTypographer(temp);
    // test for valid server response
    if (response.substring(0, 15) == Ok200Header)
      message = F("<div style=\"color: green\">The host's response is OK</div>");
    else
      message = F("<div style=\"color: red\">This is an invalid host response !</div>");
  }
  // Close the connection
  client.stop();
}
