// Hygrometer with HTU21 (SI7021) sensor and ESP8266
// Sends data to tmep.cz
// Tested with Arduino IDE 1.8.13 and ESP8266 core v.2.7.4
// 01/2021 Pavel Janko, www.fancon.cz
// MIT license, http://opensource.org/licenses/MIT
// Hardware Connections (HTU21 module to ESP8266):
// VCC - 3.3V
// GND - GND
// SDA - GPIO4
// SCL - GPIO5
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// Add libraries SparkFun_HTU21D_Breakout_Arduino_Library v.1.1.3
#include "SparkFunHTU21D.h"
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
#include <ESP8266WiFi.h>
#include <ESP8266WebServer.h>
#include <ESP8266HTTPUpdateServer.h>
#include <LittleFS.h>
//**************** Here set yours parameters ***************************
const char* Version  =  "Ver.3.";
const char* ssid     =  "SetApSSID";       // Set your WiFi SSID
const char* password =  "SetYourPassword"; // Set your WiFi password
const char* host     =  "xxxx.tmep.cz"; // Set host with your domain
const char* guid     =  "xxxxxxxxxxxx"; // Set your GUID for tmep.cz
const char  WWWAUTHENTI  = false;       // Set true for web authentication
const char* WWWUSERNAME  = "admin";     // Set www user name
const char* WWWPASSWORD  = "admin";     // Set www user password
const char* OTAUSER      = "admin";     // Set OTA name
const char* OTAPASSWORD  = "admin";     // Set OTA password
const char* OTAPATH      = "/firmware"; // Set path for update firmware
const char* SensorName   = "HTU21D-001";    // Set your sensor name
const unsigned long SensorReadPeriod = 10000L;  // Set period of sensor reading in milliseconds
const unsigned long SendPeriod   = 60000L;      // Set period of send data to tmep.cz in milliseconds
int PageRefreshPeriod      = 10;         // Period of web page refresh in seconds
bool SendToTmep = true;                  // false =  don't send data to tmep.cz
int FloatRounding  = 1;
//*********************************************************************
const char* Ok200Header  = "HTTP/1.1 200 OK";
String TimeString = "00:00:00:00";
String response = "";
String message = "Data sending is disabled";
String SymbolRefresh = "&#9899;";
String StrMacAddr;
String ResetReason;
float  temperature;
float  humidity;
float Vcc;
float PercentRssi;
int rssi;
uint8_t  VisibleCharCounter = 0;
unsigned long TimeSensorTemp = 0;
unsigned long TimeSendTemp = 0;
unsigned long FreeHeap;
ESP8266WebServer server(80);
ESP8266HTTPUpdateServer httpUpdater;
HTU21D myHumidity;
ADC_MODE(ADC_VCC);
WiFiClient client;

void setup(void) {
  ResetReason = ESP.getResetReason();
  Serial.begin(115200);
  WiFi.mode(WIFI_STA);
  WiFi.begin(ssid, password);
  pinMode(LED_BUILTIN, OUTPUT);
  Serial.println("");
  while (WiFi.status() != WL_CONNECTED) {
    // Blinking with LED during connecting to WiFi
    digitalWrite(LED_BUILTIN, LOW); delay(100); digitalWrite(LED_BUILTIN, HIGH);
    delay(400);
    Serial.print(".");
  }
  StrMacAddr = WiFi.macAddress();
  Serial.println();
  Serial.print(F("Connected to AP "));
  Serial.println(ssid);
  Serial.print(F("IP address: "));
  Serial.println(WiFi.localIP());
  Serial.print(F("MAC address: "));
  Serial.println(StrMacAddr);
  // sensor HTU21 initialization
  myHumidity.begin();
  // OTA server initialization
  httpUpdater.setup(&server, OTAPATH, OTAUSER, OTAPASSWORD);
  // File system initialization
  LittleFS.begin();
  server.serveStatic("/favicon.ico", LittleFS, "favicon.ico");
  server.serveStatic("/test.jpg", LittleFS, "test.jpg");
  server.on("/", HTTP_GET, MainPage);
  // Fast serves answer 404 File not found
  server.onNotFound (FileNotFound);
  // HTTP server initialization
  server.begin();
  Serial.println(F("Web server started!"));
  // Stops serial
  Serial.end();
}
void loop(void) {
  server.handleClient();
  // periodic sensor reading
  if ((((millis() - SensorReadPeriod) > TimeSensorTemp) && (millis() > SensorReadPeriod)) || TimeSensorTemp == 0) {
    TimeSensorTemp = millis();
    // reading valid data from sensor
    GetSensor();
  }
  // periodic sending of data to the host
  if (((((millis() - SendPeriod) > TimeSendTemp) && (millis() > SendPeriod)) || TimeSendTemp == 0) && SendToTmep) {
    TimeSendTemp = millis();
    // Send valid data to host
    SendData();
  }
}
